---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Overbound Awareness (classification)

> Excessive binding produces rigidity; identity holds but adapts poorly to new differences.

---

## Definition

- ψA sustained beyond what variability requires
- System resists necessary change
- Over-rigid identity blocks adaptation

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Over-binding | Lock rigidity | `Monitor`, `Stuck` |
| Resistance | Change block | `Update`, `Fail` |
| Rigidity | State freeze | `Check`, `Lock` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Over-binding | Too tight | "Won't let go" |
| Resistance | Can't change | "Stuck in ways" |
| Rigidity | Too fixed | "No flexibility" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Lock rigidity | Too tight | How binding traps |
| Change block | Can't change | How adaptation fails |
| State freeze | Too fixed | How flexibility dies |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Over-locked | Frozen state |
| Networks | Stale state | Rigid connection |
| Cognition | Fixed pattern | Stuck belief |
| Systems | Frozen config | No adaptation |

---

## Scale Effects

How Overbound Awareness manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Over-measurement | Wave lock |
| λV | Gate freeze | State trap |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase lock | Fixed attention |
| ∇S | Structure freeze | Rigid self |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Causal trap | Light cage |
| λV | Field lock | Frozen structure |

Note: At extreme scales, over-binding can become indistinguishable from fundamental limits (e.g., quantum measurement at ε, causal trapping at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: ignores valid supra-ε signals
- φ: stuck asymmetry bias
- ψA: excessive phase lock
- λV: over-strict gating

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Structure freeze | Pattern lock |
| Human | λV | Gate rigidity | Boundary freeze |
| Cosmic | ψA | Phase trap | Binding cage |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Over-lock | State trap | Lost freedom |
| Human | Rigidity | Change block | No growth |
| Cosmic | Freeze | Structure trap | Dead pattern |

---

## Diagnostic Checklist

Technical tests:
- [ ] Identity rejects valid updates
- [ ] Narrow observation windows
- [ ] Long recovery after change
- [ ] State flexibility lost

Humane tests:
- [ ] Feels too rigid
- [ ] Can't adapt naturally
- [ ] Resists healthy change
- [ ] Lost flexibility

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical rigidity nor experiential inflexibility alone captures its full meaning.

---

## See Also

- [[Coherent Awareness (classification)]]
- [[Desynchronized Awareness (classification)]]
- [[Intermittent Awareness (classification)]]
- [[Awareness]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented